<?php
function e(string $str): string { return htmlspecialchars($str, ENT_QUOTES, 'UTF-8'); }
function redirect(string $path): void { header('Location: ' . $path); exit; }
function input(string $key, $default = '') { return $_POST[$key] ?? $_GET[$key] ?? $default; }
function csrf_token(): string {
    if (session_status() !== PHP_SESSION_ACTIVE) session_start();
    if (empty($_SESSION['csrf'])) { $_SESSION['csrf'] = bin2hex(random_bytes(16)); }
    return $_SESSION['csrf'];
}
function csrf_verify(): bool {
    if (session_status() !== PHP_SESSION_ACTIVE) session_start();
    return isset($_POST['csrf']) && hash_equals($_SESSION['csrf'] ?? '', $_POST['csrf']);
}
function flash(string $key, string $msg = null) {
    if (session_status() !== PHP_SESSION_ACTIVE) session_start();
    if ($msg === null) { $m = $_SESSION['flash'][$key] ?? null; unset($_SESSION['flash'][$key]); return $m; }
    $_SESSION['flash'][$key] = $msg;
}
function format_date(?string $date): string { if (!$date) return ''; return date('F j, Y', strtotime($date)); }
function status_badge(string $status): string {
    $class = ['Active' => 'bg-green-600', 'Suspended' => 'bg-yellow-600', 'Expired' => 'bg-red-600'][$status] ?? 'bg-gray-600';
    return '<span class="badge ' . $class . '">' . e($status) . '</span>';
}
?>