// =============================
// File: /TradeLicense/admin/licenses.php (List + search)
// =============================
<?php
require_once __DIR__ . '/../../lib/db.php';
require_once __DIR__ . '/../../lib/functions.php';
$pdo = db();


$q = trim((string)($_GET['q'] ?? ''));
$zone = (int)($_GET['zone'] ?? 0);


$zones = $pdo->query('SELECT id, name FROM zones ORDER BY name')->fetchAll();


$sql = 'SELECT l.*, z.name AS zone_name FROM licenses l JOIN zones z ON z.id = l.zone_id WHERE 1';
$params = [];
if ($q !== '') { $sql .= ' AND (l.license_no LIKE ? OR l.trade_name LIKE ? OR l.owner_name LIKE ?)'; $params[] = "%$q%"; $params[] = "%$q%"; $params[] = "%$q%"; }
if ($zone > 0) { $sql .= ' AND l.zone_id = ?'; $params[] = $zone; }
$sql .= ' ORDER BY l.created_at DESC LIMIT 200';
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll();


include __DIR__ . '/../../partials/header.php';
?>
<section class="card">
<h2>Licenses</h2>
<?php if ($m = flash('ok')): ?><p class="help"><?= e($m) ?></p><?php endif; ?>
<form method="get" class="row" style="margin-bottom:10px">
<div>
<label class="label">Search</label>
<input class="input" type="text" name="q" placeholder="License, owner, trade" value="<?= e($q) ?>">
</div>
<div>
<label class="label">Zone</label>
<select class="input" name="zone">
<option value="0">All zones</option>
<?php foreach ($zones as $z): ?>
<option value="<?= (int)$z['id'] ?>" <?= $zone==$z['id']?'selected':'' ?>><?= e($z['name']) ?></option>
<?php endforeach; ?>
</select>
</div>
</form>
<div style="margin:8px 0 14px">
<a class="btn" href="TradeLicense/license_form.php">+ New License</a>
</div>
<table class="table">
<thead>
<tr><th>ID</th><th>Trade Name</th><th>Owner</th><th>Zone</th><th>Status</th><th>Expiry</th><th>Actions</th></tr>
</thead>
<tbody>
<?php foreach ($rows as $r): ?>
<tr>
<td><?= e($r['license_no']) ?></td>
<td><?= e($r['trade_name']) ?></td>
<td><?= e($r['owner_name']) ?></td>
<td><?= e($r['zone_name']) ?></td>
<td><?= status_badge($r['status']) ?></td>
<td><?= e(format_date($r['expiry_date'])) ?></td>
<td>
<a class="btn secondary" href="TradeLicense/license_form.php?id=<?= (int)$r['id'] ?>">Edit</a>
<a class="btn danger" href="TradeLicense/delete_license.php?id=<?= (int)$r['id'] ?>" onclick="return confirm('Delete this license?')">Delete</a>
<a class="btn" href="../verify.php?Id=<?= e(urlencode($r['license_no'])) ?>&ZoneInfoId=<?= (int)$r['zone_id'] ?>" target="_blank">View</a>
</td>
</tr>
<?php endforeach; ?>
<?php if (!$rows): ?><tr><td colspan="7" class="muted">No results</td></tr><?php endif; ?>
</tbody>
</table>
</section>
<?php include __DIR__ . '/../../partials/footer.php'; ?>